* -----------------------------------------------------------------------------
*                                                DTT (c)2006 FSL - FreeSoftLand
*  Title: GetPrinterResolution
* 
*  Date : 25/04/2006
*  By   : FSL
* -----------------------------------------------------------------------------
*
*
identification division.
program-id.   deviceinfo.
*
environment division.
configuration section.
input-output section.
file-control.
select spool assign to print "-p spooler"
organization is line sequential.
*
data division.
file section.
       fd  spool.
       01  spool-satz            pic x(80).
working-storage section.
       77 H-ACU-SPOOLER-DC       PIC 9(9) COMP-5 EXTERNAL.
       77 FunctionNumber         PIC 9(9) COMP-5.
       *Horizontal size in millimeters
       88 HORZSIZE               VALUE 04.
       *Vertical size in millimeters
       88 VERTSIZE               VALUE 06.
       *Horizontal size in pixels
       88 HORZRES                VALUE 08.
       *Vertical size in pixels
       88 VERTRES                VALUE 10.
       *Logical pixels/inch X wise
       88 LOGPIXELSX             VALUE 88.
       *Logical pixels/inch Y wise
       88 LOGPIXELSY             VALUE 90.
       *Physical width in device units
       88 PHYSICALWIDTH          VALUE 110.
       *Physical height in device units
       88 PHYSICALHEIGHT         VALUE 111.
       *Physical printable area x wise
       88 PHYSICALOFFSETX        VALUE 112.
       *Physical printable area y wise
       88 PHYSICALOFFSETY        VALUE 113.
       77 WS-HORZSIZE            PIC 9(9) COMP-5.
       77 WS-VERTSIZE            PIC 9(9) COMP-5.
       77 WS-HORZRES             PIC 9(9) COMP-5.
       77 WS-VERTRES             PIC 9(9) COMP-5.
       77 WS-LOGPIXELSX          PIC 9(9) COMP-5.
       77 WS-LOGPIXELSY          PIC 9(9) COMP-5.
       77 WS-PHYSICALWIDTH       PIC 9(9) COMP-5.
       77 WS-PHYSICALHEIGHT      PIC 9(9) COMP-5.
       77 WS-PHYSICALOFFSETX     PIC 9(9) COMP-5.
       77 WS-PHYSICALOFFSETY     PIC 9(9) COMP-5.
       77 WS-VISUAL-VAR          PIC Z(8)9.
       77 CNTL-FONT              USAGE HANDLE OF FONT SMALL-FONT.
       01 FILLER OCCURS 10.
          03 TITLE-TBL           PIC X(30).
          03 DATA-TBL            PIC Z(8)9.

SCREEN SECTION.
       01 INFO-TABLE.
          03 PUSH-BUTTON
             LINE                   18
             COLUMN                 50
             self-act
             TITLE                  "Exit".
          03 LINE 0.
          03 OCCURS 10.
             05 LINE                + 1.5.
                07 LABEL
                   TITLE            TITLE-TBL
                   COLUMN           02.
                07 ENTRY-FIELD
                   READ-ONLY
                   VALUE            DATA-TBL
                   RIGHT
                   3-D
                   COLUMN           50.

procedure division.
       main-logic.
           DISPLAY STANDARD         GRAPHICAL WINDOW
                   TITLE            "Printer features"
                   CONTROL          FONT CNTL-FONT
                   SIZE             60
                   LINES            20
                   BACKGROUND-LOW.
              set     environment      "DLL-CONVENTION" TO 1.
              call    "gdi32.dll".
           call    "win$printer"    using 2. |winprint-setup
           open    output           spool.

           set     horzsize         to true.
       call    "GetDeviceCaps"  using
                   BY VALUE         H-ACU-SPOOLER-DC
                   BY VALUE         FunctionNumber
                   GIVING           WS-HORZSIZE.

       set     VERTSIZE         to true.
       call    "GetDeviceCaps"  using
                   BY VALUE         H-ACU-SPOOLER-DC
                   BY VALUE         FunctionNumber
                   GIVING           WS-VERTSIZE.

       set     HORZRES          to true.
       call    "GetDeviceCaps"  using
                   BY VALUE         H-ACU-SPOOLER-DC
                   BY VALUE         FunctionNumber
                   GIVING           WS-HORZRES.

       set     VERTRES          to true.
       call    "GetDeviceCaps"  using
                   BY VALUE         H-ACU-SPOOLER-DC
                   BY VALUE         FunctionNumber
                   GIVING           WS-VERTRES.

       set     LOGPIXELSX       to true.
       call    "GetDeviceCaps"  using
                   BY VALUE         H-ACU-SPOOLER-DC
                   BY VALUE         FunctionNumber
                   GIVING           WS-LOGPIXELSX.

       set     LOGPIXELSY       to true.
       call    "GetDeviceCaps"  using
                   BY VALUE         H-ACU-SPOOLER-DC
                   BY VALUE         FunctionNumber
                   GIVING           WS-LOGPIXELSY.

       set     PHYSICALWIDTH    to true.
       call    "GetDeviceCaps"  using
                   BY VALUE         H-ACU-SPOOLER-DC
                   BY VALUE         FunctionNumber
                   GIVING           WS-PHYSICALWIDTH.

       set     PHYSICALHEIGHT   to true.
       call    "GetDeviceCaps"  using
                   BY VALUE         H-ACU-SPOOLER-DC
                   BY VALUE         FunctionNumber
                   GIVING           WS-PHYSICALHEIGHT.

       set     PHYSICALOFFSETX  to true.
       call    "GetDeviceCaps"  using
                   BY VALUE         H-ACU-SPOOLER-DC
                   BY VALUE         FunctionNumber
                   GIVING           WS-PHYSICALOFFSETX.

       set     PHYSICALOFFSETY  to true.
       call    "GetDeviceCaps"  using
                   BY VALUE         H-ACU-SPOOLER-DC
                   BY VALUE         FunctionNumber
                   GIVING           WS-PHYSICALOFFSETY.

           close   spool.
           cancel  "gdi32.dll".
           perform update-tables.
           perform display-results.
           stop    run.

       update-tables.

           MOVE    "Horizontal size, millimeter" TO TITLE-TBL(01).
           MOVE    "Vertical size, millimeter"   TO TITLE-TBL(02).
           MOVE    "Horizontal size, pixel"      TO TITLE-TBL(03).
           MOVE    "Vertical size, pixel"        TO TITLE-TBL(04).
           MOVE    "Logical width,  pixel"       TO TITLE-TBL(05).
           MOVE    "Logical height, pixel"       TO TITLE-TBL(06).
           MOVE    "Physical width, pixel"       TO TITLE-TBL(07).
           MOVE    "Physical height, pixel"      TO TITLE-TBL(08).
           MOVE    "Phys. Print width, pixel"    TO TITLE-TBL(09).
           MOVE    "Phys. Print height, pixel"   TO TITLE-TBL(10).
           MOVE    WS-HORZSIZE                   TO DATA-TBL(01).
           MOVE    WS-VERTSIZE                   TO DATA-TBL(02).
           MOVE    WS-HORZRES                    TO DATA-TBL(03).
           MOVE    WS-VERTRES                    TO DATA-TBL(04).
           MOVE    WS-LOGPIXELSX                 TO DATA-TBL(05).
           MOVE    WS-LOGPIXELSY                 TO DATA-TBL(06).
           MOVE    WS-PHYSICALWIDTH              TO DATA-TBL(07).
           MOVE    WS-PHYSICALHEIGHT             TO DATA-TBL(08).
           MOVE    WS-PHYSICALOFFSETX            TO DATA-TBL(09).
           MOVE    WS-PHYSICALOFFSETY            TO DATA-TBL(10).
           exit    paragraph.

       display-results.

           display info-table.
           accept  info-table.
           exit    paragraph.


